import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { OpacityDropdownComponent } from 'ui/components/closed-captions/opacity-dropdown';
import { AlignmentDropdownComponent } from 'ui/components/closed-captions/alignment-dropdown';
import { FontOpacityDropdownComponent } from 'ui/components/closed-captions/font-opacity-dropdown';
import { FontDropdownComponent } from 'ui/components/closed-captions/font-dropdown';
import { PositionDropdownComponent } from 'ui/components/closed-captions/position-dropdown';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';
import { SelectDropdown } from 'ui/components/common/select-dropdown';

const DEFAULT_ARGS = Object.freeze({
    onSelect() {},
    t: mockTranslateFunc,
});

reactTest('ui | components | closed-captions | dropdowns', function() {
    function testDropdown(Dropdown, label, props = {}) {
        const args = assign({}, DEFAULT_ARGS, props);
        const currentValueProp = Object.keys(props)[0];

        QUnit.test('should render a div with correct class', function(assert) {
            const component = shallow(<Dropdown {...args} />);
            assert.equal(component.type(), 'div');
            assert.ok(component.hasClass('cc-customize-field'), 'has correct class');
        });

        QUnit.test('should have correct text', function(assert) {
            const component = shallow(<Dropdown {...args} />);
            assert.equal(component.find('label').text(), label, 'has correct text');
        });

        QUnit.test('should pass onSelect to SelectDropdown', function(assert) {
            const component = shallow(<Dropdown {...args} />);
            const { onSelect } = component.find(SelectDropdown).props();

            assert.strictEqual(onSelect, DEFAULT_ARGS.onSelect);
        });

        QUnit.test(`should set ${props[currentValueProp]} as select value`, function(assert) {
            const component = shallow(<Dropdown {...args} />);
            const currentValue = component.find(SelectDropdown).props().currentValue;
            assert.equal(currentValue, props[currentValueProp], 'sets correct value');
        });
    }

    testDropdown(
        PositionDropdownComponent,
        'Position',
        { currentPosition: 'top' }
    );

    testDropdown(
        OpacityDropdownComponent,
        'Opacity',
        { currentOpacity: 'solid' }
    );

    testDropdown(
        FontOpacityDropdownComponent,
        'Opacity',
        { currentOpacity: 'solid' }
    );

    testDropdown(
        FontDropdownComponent,
        'Font',
        { currentFont: 'mono-serif' }
    );

    testDropdown(
        AlignmentDropdownComponent,
        'Alignment',
        { currentAlignment: 'left' }
    );
});
