import React from 'react';
import assign from 'lodash/assign';
import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { SizePaletteComponent } from 'ui/components/closed-captions/size-palette';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    increaseSize() {},
    decreaseSize() {},
    t: mockTranslateFunc,
});

function renderSizePalette(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <SizePaletteComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | closed-captions | size-palette', function() {
    QUnit.test('renders a div with correct classes', function(assert) {
        const component = renderSizePalette();
        assert.equal(component.type(), 'div');
        assert.ok(component.hasClass('cc-customize-field'), 'has correct class');
    });

    QUnit.test('renders correct label', function(assert) {
        const component = renderSizePalette();
        const label = component.find('label');
        assert.equal(label.text(), 'Size', 'renders correct label');
    });

    QUnit.test('increment button invokes increaseSize when clicked', function(assert) {
        const increaseSize = sinon.spy();
        const component = renderSizePalette({
            increaseSize,
        });

        component.find('.cc-font-size--increment').simulate('click');
        assert.equal(increaseSize.callCount, 1, 'called once');
    });

    QUnit.test('decrement button invokes increaseSize when clicked', function(assert) {
        const decreaseSize = sinon.spy();
        const component = renderSizePalette({
            decreaseSize,
        });

        component.find('.cc-font-size--decrement').simulate('click');
        assert.equal(decreaseSize.callCount, 1, 'called once');
    });
});
