import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { CollectionEmptyOverlayComponent } from 'ui/components/collections/collection-empty-overlay';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    t: mockTranslateFunc,
});

function renderCollectionEmptyOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <CollectionEmptyOverlayComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | collections/collection-empty-overlay', function() {
    QUnit.test('is a div', function(assert) {
        const component = renderCollectionEmptyOverlay();
        assert.equal(component.type(), 'div');
    });

    QUnit.test('has correct text', function(assert) {
        const component = renderCollectionEmptyOverlay();
        assert.equal(component.text(), 'This collection is empty.');
    });
});
