import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { CollectionSidebarItems } from 'ui/components/collections/collection-sidebar-items';

/* eslint-disable camelcase */
const DEFAULT_ARGS = Object.freeze({
    currentVideoId: '',
    collectionItems: [{
        itemId: '123',
        title: 'Some title',
        thumbnails: {
            small: 'http://something.com/img1',
        },
        owner: {
            displayName: 'Some gal',
        },
    }, {
        itemId: '234',
        title: 'Some title, Redux',
        thumbnails: {
            small: 'http://something.com/img2',
        },
        owner: {
            displayName: 'Some guy',
        },
    }],
});
/* eslint-enable camelcase */

function renderCollectionSidebarItems(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <CollectionSidebarItems {...args} />;
    return shallow(component);
}

reactTest('ui | components | collection-sidebar-items', function() {
    QUnit.test('renders the correct number of collection items', function(assert) {
        const component = renderCollectionSidebarItems();
        assert.equal(component.getElement().props.children.length, 2, 'renders two collection items');
        assert.equal(component.getElement().props.children[0].props['data-vod-id'], '123');
        assert.equal(component.getElement().props.children[1].props['data-vod-id'], '234');
    });

    QUnit.test('sets data-currentvod correctly', function(assert) {
        const component = renderCollectionSidebarItems();

        component.setProps({ currentVideoId: `v${DEFAULT_ARGS.collectionItems[1].itemId}` });

        assert.equal(component.getElement().props.children[0].props['data-currentvod'], false);
        assert.equal(component.getElement().props.children[1].props['data-currentvod'], true);
    });

    QUnit.test('renders basic metadata for first collection video', function(assert) {
        const component = renderCollectionSidebarItems();
        const firstVideoElem = component.find(`[data-vod-id='${DEFAULT_ARGS.collectionItems[0].itemId}']`);

        assert.equal(
            firstVideoElem.find('.qa-collection-item-number').text(),
            '1',
            'first video element\'s index is 1'
        );

        assert.equal(
            firstVideoElem.find('.qa-collection-item-thumbnail').props().src,
            DEFAULT_ARGS.collectionItems[0].thumbnails.small,
            'first video element\'s thumbnail src renders properly'
        );

        assert.equal(
            firstVideoElem.find('.qa-collection-item-title').text(),
            DEFAULT_ARGS.collectionItems[0].title,
            'first video element\'s title renders properly'
        );

        assert.equal(
            firstVideoElem.find('.qa-collection-item-channel').text(),
            DEFAULT_ARGS.collectionItems[0].owner.displayName,
            'first video element\'s owner\'s display name renders properly'
        );
    });
});
