import React from 'react';
import merge from 'lodash/merge';
import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { FeaturedCollectionComponent } from 'ui/components/collections/featured-collection';
import { PlayerCard } from 'ui/components/recommendations/cards/player-card';

const DEFAULT_ARGS = {
    featuredCollection: {
        id: '',
        title: '',
        itemsCount: 0,
        owner: {
            displayName: '',
            id: '',
            name: '',
        },
    },
    thumbnailURL: '',
    onSelect() {},
};

function renderFeaturedCollection(overrides = {}) {
    const args = merge({}, DEFAULT_ARGS, overrides);
    const component = <FeaturedCollectionComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | collections | featured-collection', function() {
    QUnit.test('Renders a PlayerCard', function(assert) {
        const component = renderFeaturedCollection();
        assert.equal(component.type(), PlayerCard);
    });

    QUnit.test('Passes PlayerCard the featured collection\'s title', function(assert) {
        const title = QUnit.config.current.testId;
        const component = renderFeaturedCollection({
            featuredCollection: {
                title,
            },
        });

        const infoComponent = shallow(component.props().info);
        assert.equal(infoComponent.text(), title);
    });

    QUnit.test('Passes PlayerCard the correct thumbnailURL', function(assert) {
        const thumbnailURL = QUnit.config.current.testId;
        const component = renderFeaturedCollection({ thumbnailURL });

        assert.equal(component.props().thumbnailURL, thumbnailURL);
    });

    QUnit.test('Passes onSelect to PlayerCard', function(assert) {
        const onSelect = sinon.spy();
        const component = renderFeaturedCollection({ onSelect });

        component.props().onSelect();

        assert.equal(onSelect.callCount, 1);
    });

    QUnit.test('Passes PlayerCard correct className', function(assert) {
        const component = renderFeaturedCollection();
        assert.equal(component.props().className, 'pl-rec__item');
    });
});
