import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { LinkedImage } from 'ui/components/common/linked-image';

const DEFAULT_ARGS = Object.freeze({
    classNames: {},
    alt: '',
    imgSrc: '',
    href: '',
    target: '',
});

function renderLinkedImage(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <LinkedImage {...args} />;
    return shallow(component);
}

reactTest('ui | components | linked-image ', function() {
    QUnit.test('defaultly returns <a> and <img> elements', function(assert) {
        const anchor = renderLinkedImage();

        assert.equal(anchor.type(), 'a', 'should generate an anchor element');
        assert.ok(anchor.hasClass(''), '<a> should have empty class');
        assert.equal(anchor.prop('href'), '', '<a> should have empty href');
        assert.equal(anchor.prop('target'), '', '<a> should have empty target');
        assert.equal(anchor.prop('onClick'), undefined, '<a> should not have onClick defined');
        assert.equal(anchor.children().length, 1, 'should have one child');
        const img = anchor.childAt(0);
        assert.equal(img.type(), 'img', '<a> should have an img child element');
        assert.ok(img.hasClass(''), '<img> should have empty class');
        assert.equal(img.prop('alt'), '', '<img> should have empty alt');
        assert.equal(img.prop('src'), '', '<img> should have empty src');
    });

    QUnit.test('returns <a> and <img> elements with the expected input', function(assert) {
        const input = {
            alt: 'alttext',
            classNames: {
                a: 'anchor',
                img: 'image',
            },
            imgSrc: 'https://some.image/',
            href: 'https://some.url/',
            onClick: () => {},
            target: '_blank',
        };
        const anchor = renderLinkedImage(input);

        assert.equal(anchor.type(), 'a', 'should generate an anchor element');
        assert.ok(anchor.hasClass(input.classNames.a), '<a> should have given input class');
        assert.equal(anchor.prop('href'), input.href, '<a> should have given href');
        assert.equal(anchor.prop('target'), input.target, '<a> should have given target');
        assert.equal(anchor.prop('onClick'), input.onClick, '<a> should have given onClick function');
        assert.equal(anchor.children().length, 1, '<a> should have one child');
        const img = anchor.childAt(0);
        assert.equal(img.type(), 'img', '<a>should have an img child element');
        assert.ok(img.hasClass('image'), '<img> should have "image" class');
        assert.equal(img.prop('alt'), input.alt, '<img> should have given alt');
        assert.equal(img.prop('src'), input.imgSrc, '<img> should have given src');
    });
});
