import React from 'react';
import assign from 'lodash/assign';
import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { ToggleComponent } from 'ui/components/common/toggle';

const TOGGLE_CHECKBOX_INPUT = '.qa-input-checkbox';

const DEFAULT_ARGS = Object.freeze({
    t: str => str,
    onToggle() {},
    toggledOn: false,
    label: 'LABEL1',
});

function renderToggle(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ToggleComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | common | toggle', function() {
    QUnit.test('returns a div', function(assert) {
        const component = renderToggle();
        assert.equal(component.type(), 'div');
    });

    QUnit.test('changing checkbox invokes onToggle prop', function(assert) {
        const onToggleSpy = sinon.spy();
        const component = renderToggle({
            onToggle: onToggleSpy,
        });

        component.find(TOGGLE_CHECKBOX_INPUT).simulate('change');
        assert.equal(onToggleSpy.callCount, 1);
    });

    QUnit.test('input checked value determined by toggledOn prop', function(assert) {
        const component = renderToggle({
            toggledOn: true,
        });

        assert.ok(component.find(TOGGLE_CHECKBOX_INPUT).props().checked, 'checked is true');

        component.setProps({
            toggledOn: false,
        });

        assert.equal(component.find(TOGGLE_CHECKBOX_INPUT).props().checked, false, 'checked is false');
    });

    QUnit.test('clicking the label triggers the onToggle prop as well', function(assert) {
        const toggleSpy = sinon.spy();
        const component = renderToggle({
            onToggle: toggleSpy,
        });

        component.find('.qa-toggle-label').simulate('click');

        assert.equal(toggleSpy.callCount, 1);
    });
});
