import React from 'react';
import assign from 'lodash/assign';
import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { createExtensionParsed } from 'tests/fixtures/extensions';
import { ExtensionListButton } from 'ui/components/extensions/extension-list-button';
import { Button } from 'ui/components/buttons/base-button';

const DEFAULT_ARGS = Object.freeze({
    extension: createExtensionParsed()[0],
    onClick() {},
});

function renderButton(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ExtensionListButton {...args} />;
    return shallow(component);
}

reactTest('ui | components | extensions | extension-list-button', function() {
    QUnit.test('is rendered correctly', function(assert) {
        const component = renderButton();
        const extensionButton = component.find(Button);
        assert.ok(extensionButton.length, 1, 'component rendered a single button');
    });

    QUnit.test('when button is clicked', function(assert) {
        const onClickSpy = sinon.spy();
        const component = renderButton({
            onClick: onClickSpy,
        });

        const extensionButton = component.find(Button);
        extensionButton.simulate('click');
        assert.equal(onClickSpy.callCount, 1,
            'click handler is called');
        assert.deepEqual(onClickSpy.firstCall.args[0], DEFAULT_ARGS.extension,
            'click handler is called with expected value');
    });
});
