import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import assign from 'lodash/assign';
import sinon from 'sinon';
import { mount } from 'enzyme';
import { createExtensionParsed } from 'tests/fixtures/extensions';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';
import { ExtensionListMenuComponent } from 'ui/components/extensions/extension-list-menu';
import { Button } from 'ui/components/buttons/base-button';

const DEFAULT_ARGS = Object.freeze({
    extensions: createExtensionParsed(),
    onExtensionClick() {},
    t: mockTranslateFunc,
});

function renderMenu(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ExtensionListMenuComponent {...args} />;
    return mount(component);
}

reactTest('ui | components | extensions | extension-list-menu', function() {
    QUnit.test('when extension button is clicked', function(assert) {
        const extensionClickSpy = sinon.spy();
        const component = renderMenu({
            onExtensionClick: extensionClickSpy,
        });

        const extensionButton = component.find(Button).first();
        extensionButton.simulate('click');
        assert.equal(extensionClickSpy.callCount, 1,
            'extension click handler is called');
        assert.equal(extensionClickSpy.firstCall.args[0], DEFAULT_ARGS.extensions[0],
            'extension click handler is called with expected value');
    });
});
