import React from 'react';
import assign from 'lodash/assign';
import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { ExtensionSettingsButton } from 'ui/components/extensions/extension-settings-button';
import { Button } from 'ui/components/buttons/base-button';
import { Icon } from 'ui/components/buttons/base-icon';

const DEFAULT_ARGS = Object.freeze({
    onClick() {},
});

function renderButton(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ExtensionSettingsButton {...args} />;
    return shallow(component);
}

reactTest('ui | components | extensions | extension-settings-button', function() {
    QUnit.test('is rendered correctly', function(assert) {
        const component = renderButton();
        const extensionButton = component.find(Button);
        const extensionIcon = component.find(Icon);
        assert.ok(extensionButton.length, 1, 'component rendered a single button');
        assert.ok(extensionIcon.length, 1, 'component rendered a single icon');
    });

    QUnit.test('when button is clicked', function(assert) {
        const onClickSpy = sinon.spy();
        const component = renderButton({
            onClick: onClickSpy,
        });

        const extensionButton = component.find(Button);
        extensionButton.simulate('click');
        assert.equal(onClickSpy.callCount, 1,
            'click handler is called');
    });
});
