import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { CenteredFollowPanelComponent } from 'ui/components/follow-panels/centered-panel';
import { NotificationsButton } from 'ui/components/buttons/notifications-button';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    t: mockTranslateFunc,
    enable: () => {},
    disable: () => {},
    notificationsEnabled: false,
    channelName: '',
});

function renderCenteredFollowPanel(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <CenteredFollowPanelComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | follow-panels | centered-panel ', function() {
    QUnit.test('should have correct title', function(assert) {
        const component = renderCenteredFollowPanel();
        const expected = 'Live Broadcast has ended';

        assert.equal(component.childAt(0).text(), expected);
    });

    QUnit.test('should have correct subtitle', function(assert) {
        const channelName = QUnit.config.current.testId;
        const component = renderCenteredFollowPanel({
            channelName,
        });
        const expected = `Get notified when ${channelName} goes live next`;

        assert.equal(component.childAt(1).text(), expected);
    });

    QUnit.test('should have correct class', function(assert) {
        const component = renderCenteredFollowPanel();
        assert.ok(component.hasClass('pl-pinned-panel--embed'));
    });

    QUnit.test('should have a notifications button', function(assert) {
        const component = renderCenteredFollowPanel();

        assert.equal(
            component.find(NotificationsButton).length,
            1,
            'Has one NotificationsButton'
        );
    });
});
