import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { GenericFollowPanelComponent } from 'ui/components/follow-panels/generic-panel';
import { NotificationsButton } from 'ui/components/buttons/notifications-button';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    t: mockTranslateFunc,
    enable: () => {},
    disable: () => {},
    notificationsEnabled: false,
    channelName: '',
    withInfo: false,
});

function renderGenericFollowPanel(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <GenericFollowPanelComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | follow-panels | channel-page-panel ', function() {
    QUnit.test('should have correct title', function(assert) {
        const channelName = QUnit.config.current.testId;
        const component = renderGenericFollowPanel({
            channelName,
        });

        assert.equal(component.childAt(0).text(), `Follow and get notified when ${channelName} is live`);
    });

    QUnit.test('should have correct classes when stream info is being displayed', function(assert) {
        const component = renderGenericFollowPanel({
            withInfo: true,
        });
        assert.ok(component.hasClass('pl-pinned-panel--with-info'));
    });

    QUnit.test('should have a notifications button', function(assert) {
        const component = renderGenericFollowPanel();

        assert.equal(
            component.find(NotificationsButton).length,
            1,
            'Has one NotificationsButton'
        );
    });
});
