import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { TwitchEverywhereFollowPanel } from 'ui/components/follow-panels/twitch-everywhere-panel';
import { FollowButton } from 'ui/containers/buttons/follow-button';
import { SubscribeButton } from 'ui/containers/buttons/subscribe-button';
import { DEFAULT_AVATAR_URL } from 'settings';

const DEFAULT_ARGS = Object.freeze({
    onFollowChannel: () => {},
    onUnfollowChannel: () => {},
    isFollowing: false,
    onSubscribe: () => {},
    isSubscribed: false,
    isSubscribable: true,
    channelName: 'channel-name',
    avatarURL: 'avatar-url',
    withInfo: false,
});

reactTest('ui | components | follow-panels | twitch-everywhere-panel', function() {
    QUnit.test('has correct image src', function(assert) {
        const component = shallow(
            <TwitchEverywhereFollowPanel {...DEFAULT_ARGS} />
        );

        const image = component.find('img');

        assert.equal(image.props().src, 'avatar-url');
    });

    QUnit.test('falls back to a default image when there is no avatarURL', function(assert) {
        const component = shallow(
            <TwitchEverywhereFollowPanel {...DEFAULT_ARGS} avatarURL={''} />
        );

        const image = component.find('img');

        assert.equal(image.props().src, DEFAULT_AVATAR_URL);
    });

    QUnit.test('should render a follow button', function(assert) {
        const component = shallow(
            <TwitchEverywhereFollowPanel {...DEFAULT_ARGS} />
        );

        assert.ok(
            component.contains(
                <FollowButton
                    onFollowChannel={DEFAULT_ARGS.onFollowChannel}
                    onUnfollowChannel={DEFAULT_ARGS.onUnfollowChannel}
                />
            ),
            'Renders follow button with correct args'
        );
    });

    QUnit.test('should render a subscribe button', function(assert) {
        const component = shallow(
            <TwitchEverywhereFollowPanel {...DEFAULT_ARGS} />
        );

        assert.ok(
            component.contains(
                <SubscribeButton onSubscribe={DEFAULT_ARGS.onSubscribe} />
            ),
            'Renders subscribe button with correct args'
        );
    });
});
