import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { UnavailableContentFollowPanelComponent } from 'ui/components/follow-panels/unavailable-content-panel';
import { NotificationsButton } from 'ui/components/buttons/notifications-button';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    t: mockTranslateFunc,
    enable: () => {},
    disable: () => {},
    notificationsEnabled: false,
    channelName: '',
    withInfo: false,
});

function renderUnavailableContentFollowPanel(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <UnavailableContentFollowPanelComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | follow-panels | unavailable-content-panel ', function() {
    QUnit.test('should have correct title', function(assert) {
        const channelName = QUnit.config.current.testId;
        const component = renderUnavailableContentFollowPanel({
            channelName,
        });

        assert.equal(component.childAt(0).text(), `Get notified when ${channelName} goes live next`);
    });

    QUnit.test('should have a notifications button', function(assert) {
        const component = renderUnavailableContentFollowPanel();

        assert.equal(
            component.find(NotificationsButton).length,
            1,
            'Has one NotificationsButton'
        );
    });
});
