import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { AdOverlayComponent } from 'ui/components/overlays/ad-overlay';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    clickThroughUrl: '',
    adLabel: 'Advertisement',
    t: mockTranslateFunc,
});

function renderAdOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <AdOverlayComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | overlays | ad-overlay', function() {
    QUnit.test('renders a div with the correct classes', function(assert) {
        const component = renderAdOverlay();
        assert.equal(component.type(), 'div', 'is div');
        assert.ok(component.childAt(0).hasClass('player-overlay', 'has player-overlay class'));
        assert.ok(component.childAt(0).hasClass('player-ad-overlay', 'has player-ad-overlay class'));
    });

    QUnit.test('sets the clickThroughUrl when specified', function(assert) {
        const clickThroughUrl = QUnit.config.current.testId;
        const component = renderAdOverlay({ clickThroughUrl });
        const anchor = component.find('a');

        assert.equal(anchor.props().href, clickThroughUrl, 'anchor tag has href');
    });
});
