import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { ChromecastOverlayComponent } from 'ui/components/overlays/chromecast-overlay';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    deviceName: '',
    t: mockTranslateFunc,
});

function renderChromecastOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ChromecastOverlayComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | overlays | chromecast overlay', function() {
    QUnit.test('should render a div with the correct classes', function(assert) {
        const component = renderChromecastOverlay();
        assert.equal(component.type(), 'div');
        assert.ok(component.hasClass('pl-chromecast-overlay'), 'has class pl-chromecast-overlay');
        assert.ok(component.hasClass('player-overlay'), 'has class player-overlay');
    });

    QUnit.test('should render a inner div with correct centered class', function(assert) {
        const component = renderChromecastOverlay();
        assert.equal(component.childAt(0).type(), 'div');
        assert.ok(component.childAt(0).hasClass('player-center-content'), 'has correct class');
    });

    QUnit.test('should render correct copy', function(assert) {
        const component = renderChromecastOverlay({
            deviceName: QUnit.config.current.testId,
        });
        assert.equal(component.text(), `Playing on ${QUnit.config.current.testId}`);
    });
});
