import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { ErrorOverlayComponent } from 'ui/components/overlays/error-overlay';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    errorMessage: '',
    errorCode: 0,
    t: mockTranslateFunc,
});

function renderErrorOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ErrorOverlayComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | overlays | error-overlay', function() {
    QUnit.test('should render a div', function(assert) {
        const component = renderErrorOverlay();
        assert.equal(component.type(), 'div');
        assert.ok(component.hasClass('pl-error'), 'has pl-error class');
    });

    QUnit.test('should have a player-center-content class', function(assert) {
        const component = renderErrorOverlay();
        assert.equal(component.childAt(0).type(), 'div');
        assert.ok(component.childAt(0).hasClass('player-center-content'), 'has player-center-content');
    });

    QUnit.test('should have translated text with error code', function(assert) {
        const errorMessage = 'a message';
        const errorCode = 1000;
        const component = renderErrorOverlay({
            errorMessage,
            errorCode,
        });
        assert.equal(component.text(), `${errorCode}: ${errorMessage}`);
    });
});
