import React from 'react';
import assign from 'lodash/assign';
import { LoadingOverlay } from 'ui/components/overlays/loading-overlay';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { UserOfflineOverlay } from 'ui/components/overlays/user-offline-overlay';

const DEFAULT_ARGS = Object.freeze({
    shouldShowOfflineOverlay: false,
});

function renderLoadingOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <LoadingOverlay {...args} />;
    return shallow(component);
}

reactTest('ui | components | overlays | loading-overlay', function() {
    QUnit.test('should match the following markup if shouldShowOfflineOverlay is false', function(assert) {
        const component = renderLoadingOverlay({
            shouldShowOfflineOverlay: false,
        });

        assert.ok(component.containsMatchingElement(
            <div className="pl-overlay pl-overlay--loading">
                <div className="player-center-content">
                    <div className="pl-loading-spinner" />
                </div>
            </div>
        ));
    });

    QUnit.test('if shouldShowOfflineOverlay, render a UserOfflineOverlay after spinner', function(assert) {
        const component = renderLoadingOverlay({
            shouldShowOfflineOverlay: true,
        });

        const innerContainer = component.childAt(0);

        assert.equal(innerContainer.childAt(1).type(), UserOfflineOverlay, 'has UserOfflineOverlay');
        assert.ok(innerContainer.childAt(0).contains(<div className="pl-loading-spinner" />), 'after loading spinner');
    });
});
