import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { MatureOverlayComponent } from 'ui/components/overlays/mature-overlay';

const DEFAULT_ARGS = Object.freeze({
    handleMatureAccepted: () => { },
    t() {},
});

function renderMatureOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <MatureOverlayComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | overlays | mature overlay', function() {
    QUnit.test('should render a div with the correct classes', function(assert) {
        const component = renderMatureOverlay();
        const expectedClassNames = [
            'player-overlay',
            'pl-age-restriction-overlay--wall',
            'pl-age-restriction-overlay',
        ];

        assert.equal(component.type(), 'div');
        assert.ok(expectedClassNames.every(
            componentClass => component.hasClass(componentClass)), 'has class ${componentClass}');
    });

    QUnit.test('should render an inner div with center content classes', function(assert) {
        const component = renderMatureOverlay();
        assert.equal(component.childAt(0).type(), 'div');
        assert.ok(component.childAt(0).hasClass('player-center-content'), 'has player-center-content class');
    });

    QUnit.test('should have mature warning button class', function(assert) {
        const component = renderMatureOverlay();
        const expectedClassNames = [
            '.player-content-button',
            '.js-player-mature-accept',
            '.js-mature-accept-label',
        ];

        assert.ok(expectedClassNames.every(
            componentClass => component.find(componentClass)), 'has class ${componentClass}');
    });
});
