import React from 'react';
import assign from 'lodash/assign';
import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { PlayButtonOverlay } from 'ui/components/overlays/play-button-overlay';
import { Button } from 'ui/components/buttons/base-button';

const DEFAULT_ARGS = {
    collectionsSidebarOpen: false,
    onClick() {},
};

function renderPlayButtonOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <PlayButtonOverlay {...args} />;
    return shallow(component);
}

reactTest('ui | components | overlays | play-button-overlay', function() {
    QUnit.test('should render a div with the correct classes', function(assert) {
        const component = renderPlayButtonOverlay();
        assert.equal(component.type(), 'div');
        assert.ok(component.hasClass('player-play-overlay'), 'has class player-play-overlay');
        assert.ok(component.hasClass('player-overlay'), 'has class player-overlay');
    });

    QUnit.test('should have a play button when sidebar isn\'t open', function(assert) {
        const component = renderPlayButtonOverlay();
        const button = component.find('.player-button-play');
        assert.equal(button.type(), Button, 'has button');
        assert.equal(button.childAt(0).type(), 'svg', 'has svg icon');
        assert.ok(button.childAt(0).hasClass('player-icon-play'), 'has correct class');
    });

    QUnit.test('should not have a play button when sidebar is open', function(assert) {
        const component = renderPlayButtonOverlay({
            collectionsSidebarOpen: true,
        });
        const button = component.childAt(0);
        assert.equal(button.type(), null);
    });

    QUnit.test('should fire onClick handler when clicked', function(assert) {
        const onClick = sinon.spy();
        const component = renderPlayButtonOverlay({ onClick });
        component.find('.player-button-play').simulate('click');

        assert.equal(onClick.callCount, 1, 'called once');
    });
});
