import React from 'react';
import assign from 'lodash/assign';
import { shallow } from 'enzyme';
import { reactTest } from 'tests/utils/react-test';
import { StormWarningComponent } from 'ui/components/overlays/storm-warning';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    t: mockTranslateFunc,
});

function renderStormWarningOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <StormWarningComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | overlays | storm-warning', function() {
    QUnit.test('should render a div', function(assert) {
        const component = renderStormWarningOverlay();
        assert.equal(component.type(), 'div', 'renders a div');
        assert.ok(component.hasClass('pl-storm-warning'), 'has pl-storm-warning class');
    });

    QUnit.test('should have a player-center-content class', function(assert) {
        const component = renderStormWarningOverlay();
        assert.equal(component.childAt(0).type(), 'div', 'renders a div');
        assert.ok(component.childAt(0).hasClass('player-center-content'), 'has player-center-content');
    });

    QUnit.test('should have a pl-loading-spinner class', function(assert) {
        const component = renderStormWarningOverlay();
        const { className } = component.find('.pl-loading-spinner').props();
        assert.equal(className, 'pl-loading-spinner', 'has expected class name');
    });

    QUnit.test('should have a broadcast-down-label class', function(assert) {
        const component = renderStormWarningOverlay();
        const { className } = component.find('.broadcast-down-label').props();
        assert.equal(className, 'broadcast-down-label', 'has expected class name');
    });

    QUnit.test('should have a broadcast-reload-label class', function(assert) {
        const component = renderStormWarningOverlay();
        const { className } = component.find('.broadcast-reload-label').props();
        assert.equal(className, 'broadcast-reload-label', 'has expected class name');
    });

    QUnit.test('should have translated text', function(assert) {
        // eslint-disable-next-line max-len
        const stormWarningText = 'The broadcast is down.The player will automatically reload when the broadcast is back.';
        const component = renderStormWarningOverlay();
        assert.equal(component.text(), stormWarningText, 'has expected text');
    });
});
