import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { SubscribeOverlayComponent } from 'ui/components/overlays/subscribe-overlay';

const DEFAULT_ARGS = Object.freeze({
    channelName: '',
    subscriberOnlyMessage: '',
    subscribeUrl: '',
    t() {},
});

function renderSubscribeOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <SubscribeOverlayComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | overlays | subscribe overlay', function() {
    QUnit.test('should render a div with the correct classes', function(assert) {
        const component = renderSubscribeOverlay();
        const { className } = component.find('.pl-product-overlay').props();

        assert.equal(component.type(), 'div', 'has expected type.');
        assert.equal(className, 'pl-subscribe-overlay pl-subscribe-overlay--wall pl-product-overlay',
            'has expected class names.');
    });

    QUnit.test('should render an inner div with the correct classes', function(assert) {
        const component = renderSubscribeOverlay();
        const { className } = component.find('.player-product').props();

        assert.equal(component.type(), 'div', 'has expected type.');
        assert.equal(className, 'player-center-content player-product', 'has expected class names.');
    });

    QUnit.test('should have a subscribe button with the correct class', function(assert) {
        const subscribeUrl = 'test/url';
        const component = renderSubscribeOverlay({ subscribeUrl });
        const { className } = component.find('.purchase_button').props();
        const anchor = component.find('a');

        assert.equal(className, 'purchase_button', 'has expected class name.');
        assert.equal(component.find('.purchase_button').length, 1, 'should have subscribe button.');
        assert.equal(anchor.props().href, subscribeUrl, 'anchor tag has href');
    });

    QUnit.test('should have <p></p> tags', function(assert) {
        const component = renderSubscribeOverlay();
        const paragraph = component.find('p');

        assert.equal(paragraph.length, 1, 'should have <p> tags.');
    });
});
