import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { InfoDateLength } from 'ui/components/recommendations/cards/info-date-length';
import { toArray } from 'util/timestamp';
import sinon from 'sinon';

const DATE_RESPONSE = 'a formatted date string';
const I18N_LANG_CODE = 'a lang code';
const CORRECT_LOCALE_DATE_OPTIONS = {
    year: 'numeric',
    month: 'short',
    day: 'numeric',
};

reactTest('ui | components | recommendations | cards | info-date-length', function(hooks) {
    hooks.beforeEach(function() {
        this.mockDate = {
            toLocaleDateString: () => DATE_RESPONSE,
        };
    });

    QUnit.test('properly translates, formats, and displays date', function(assert) {
        sinon.stub(this.mockDate, 'toLocaleDateString', () => DATE_RESPONSE);

        const InfoDateLengthComponent = shallow(
            <InfoDateLength
                date={this.mockDate}
                length={100}
                languageCode={I18N_LANG_CODE}
            />
        );

        assert.equal(this.mockDate.toLocaleDateString.callCount, 1);
        assert.equal(this.mockDate.toLocaleDateString.firstCall.args[0], I18N_LANG_CODE);
        assert.deepEqual(this.mockDate.toLocaleDateString.firstCall.args[1], CORRECT_LOCALE_DATE_OPTIONS);

        const formattedDateElement = InfoDateLengthComponent.childAt(0);

        assert.equal(formattedDateElement.type(), 'span');
        assert.equal(formattedDateElement.text(), DATE_RESPONSE);
    });

    QUnit.test('properly formats and displays length', function(assert) {
        const length = 10000;

        const InfoDateLengthComponent = shallow(
            <InfoDateLength
                date={this.mockDate}
                length={length}
                languageCode={I18N_LANG_CODE}
            />
        );

        const formattedLengthElement = InfoDateLengthComponent.childAt(2);

        const [
            expectedHours,
            expectedMinutes,
            expectedSeconds,
        ] = toArray(length);

        const expectedFormattedLength = `${expectedHours}:${expectedMinutes}:${expectedSeconds}`;

        assert.equal(formattedLengthElement.type(), 'span');
        assert.equal(formattedLengthElement.text(), expectedFormattedLength);
    });
});
