import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { AutoplayProgressBar } from 'ui/components/recommendations/cards/progress-bar';

function shallowRenderProgressBar(percentage) {
    const component = <AutoplayProgressBar percentage={percentage} />;
    return shallow(component);
}

reactTest('ui | components | recommendations | cards | progress-bar', function() {
    // eslint-disable-next-line max-len
    QUnit.test('if percentage prop is a finite number, between 0 and 100 inclusive, render progress bar with right style width', function(assert) {
        const validPercentage = 50;
        const progressBarComponent = shallowRenderProgressBar(validPercentage);
        const progressBarFillComponent = progressBarComponent.childAt(0);

        assert.ok(progressBarComponent.hasClass('pl-card__progress-bar'));
        assert.equal(progressBarComponent.children().length, 1);
        assert.ok(progressBarFillComponent.hasClass('pl-card__progress-bar--fill'));
        assert.equal(progressBarFillComponent.prop('style').width, `${validPercentage}%`);
    });

    QUnit.test('if percentage prop is not valid, do not render anything', function(assert) {
        assert.equal(shallowRenderProgressBar(Infinity).type(), null);
        assert.equal(shallowRenderProgressBar(-1).type(), null);
        assert.equal(shallowRenderProgressBar(101).type(), null);
        assert.equal(shallowRenderProgressBar('hello').type(), null);
    });
});
