import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { MutedSegments } from 'ui/components/seekbar/muted-segments';
import { TEST_NORMALIZED_MUTED_SEGMENTS } from 'tests/fixtures/timeline-metadata';

reactTest('ui | components | seekbar | muted-segments', function() {
    QUnit.test('does not create any muted segments when duration is <= 0 or infinite', function(assert) {
        let wrapper = shallow(
            <MutedSegments
                duration={0}
                mutedSegments={TEST_NORMALIZED_MUTED_SEGMENTS}
            />
        );

        assert.equal(wrapper.children().length, 0);

        wrapper = shallow(
            <MutedSegments
                duration={-20}
                mutedSegments={TEST_NORMALIZED_MUTED_SEGMENTS}
            />
        );

        assert.equal(wrapper.children().length, 0);

        wrapper = shallow(
            <MutedSegments
                duration={Infinity}
                mutedSegments={TEST_NORMALIZED_MUTED_SEGMENTS}
            />
        );

        assert.equal(wrapper.children().length, 0);
    });

    QUnit.test('does not create any muted segments when there are no muted segments', function(assert) {
        const wrapper = shallow(
            <MutedSegments
                duration={100}
                mutedSegments={[]}
            />
        );

        assert.equal(wrapper.children().length, 0);
    });

    QUnit.test('creates muted segments when there are muted segments and a positive finite duration', function(assert) {
        const duration = 100;
        const wrapper = shallow(
            <MutedSegments
                duration={duration}
                mutedSegments={TEST_NORMALIZED_MUTED_SEGMENTS}
            />
        );

        assert.ok(wrapper.hasClass('player-slider__muted-segments js-muted-segments-container'));
        assert.equal(wrapper.children().length, TEST_NORMALIZED_MUTED_SEGMENTS.length);

        TEST_NORMALIZED_MUTED_SEGMENTS.forEach(segment => {
            assert.ok(wrapper.containsMatchingElement(
                <span
                    className="player-slider__muted"
                    style={{
                        width: `${(segment.duration / duration) * 100}%`,
                        left: `${(segment.offset / duration) * 100}%`,
                    }}
                    key={`${segment.offset}_${segment.duration}_${duration}`}
                />
            ));
        });
    });
});
