import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { SeekbarBuffer } from 'ui/components/seekbar/seekbar-buffer';

reactTest('ui | components | seekbar | seekbar-buffer', function() {
    QUnit.test('sets width to percentage of buffer length', function(assert) {
        const wrapper = shallow(
            <SeekbarBuffer
                min={0}
                max={100}
                start={25}
                end={30}
                className="seekbar-buffer"
            />
        );

        assert.equal(wrapper.prop('style').width, '5%');
    });

    QUnit.test('sets left position to percentage of value', function(assert) {
        const wrapper = shallow(
            <SeekbarBuffer
                min={0}
                max={100}
                start={40}
                end={60}
                className="seekbar-buffer"
            />
        );

        assert.equal(wrapper.prop('style').left, '40%');
    });
});
