import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { SeekbarTimeDisplay } from 'ui/components/seekbar/seekbar-time-display';
import * as Timestamp from 'util/timestamp';

reactTest('ui | components | seekbar | seekbar-time-display', function() {
    QUnit.test('has parent div with two span children', function(assert) {
        const component = shallow(
            <SeekbarTimeDisplay />
        );
        assert.equal(component.type(), 'div');
        assert.equal(component.children().length, 2);
        assert.equal(component.childAt(0).type(), 'span');
        assert.equal(component.childAt(1).type(), 'span');
    });

    QUnit.test('spans have expected class names', function(assert) {
        const component = shallow(
            <SeekbarTimeDisplay />
        );

        assert.ok(component.hasClass('player-seek__time-container'));
        assert.ok(component.childAt(0).hasClass('player-seek__time'));
        assert.ok(component.childAt(1).hasClass('player-seek__time player-seek__time--total'));
    });

    QUnit.test('uses formatted current time and duration', function(assert) {
        const currentTime = 5;
        const duration = 300;

        const component = shallow(
            <SeekbarTimeDisplay
                currentTime={currentTime}
                duration={duration}
            />
        );

        assert.equal(component.childAt(0).text(), Timestamp.toString(currentTime));
        assert.equal(component.childAt(1).text(), Timestamp.toString(duration));
    });
});
