import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import assign from 'lodash/assign';
import { ThumbnailPreviews } from 'ui/components/seekbar/thumbnail-previews';
import { TEST_PREVIEWS, TEST_PREVIEW_POPUP_OBJECT } from 'tests/fixtures/timeline-metadata';
const TEST_POPUP_PROPS = {
    duration: 100,
    previews: TEST_PREVIEWS,
    mouseMoveClientX: 30,
    seekbarWidth: 100,
    seekbarLeftOffset: 0,
};

function renderThumbnailPreviews(overrides = {}) {
    const args = assign({}, TEST_POPUP_PROPS, overrides);
    const component = <ThumbnailPreviews {...args} />;
    return shallow(component);
}

reactTest('ui | components | seekbar | thumbnail-previews', function() {
    QUnit.test('creates SeekbarPopup with correct props', function(assert) {
        const {
            mouseMoveClientX,
            seekbarLeftOffset,
        } = TEST_POPUP_PROPS;

        const component = renderThumbnailPreviews();
        const seekbarProps = component.props();

        const expectedPopupLeftOffset = mouseMoveClientX - seekbarLeftOffset;
        const expectedPopupWidth = 148;

        assert.equal(
            seekbarProps.popupLeftOffset,
            expectedPopupLeftOffset,
            'Passes correct left offset'
        );

        assert.equal(
            seekbarProps.popupWidth,
            expectedPopupWidth,
            'Passes correct popup width'
        );

        assert.deepEqual(
            seekbarProps.popupObject,
            TEST_PREVIEW_POPUP_OBJECT,
            'Passes correct popup object'
        );
    });
});
