import React from 'react';
import assign from 'lodash/assign';
import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { PlaybackSpeedButton } from 'ui/components/settings/playback-speed-button';
import { Button } from 'ui/components/buttons/base-button';

const DEFAULT_ARGS = Object.freeze({
    isActive: false,
    label: '',
    onClick() {},
    speedValue: 1.0,
});

function renderSpeedButton(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <PlaybackSpeedButton {...args} />;
    return shallow(component);
}

reactTest('ui | components | settings | playback-speed-button', function() {
    QUnit.test('render a div', function(assert) {
        const component = renderSpeedButton();
        assert.equal(component.type(), 'div');
    });

    QUnit.test('if isActive, has active class', function(assert) {
        const component = renderSpeedButton({
            isActive: true,
        });

        assert.ok(component.hasClass('pl-menu__item--active'));
    });

    QUnit.test('clicking the Button will trigger the onClick prop with the speed value', function(assert) {
        const spy = sinon.spy();
        const speedValue = 2.0;
        const component = renderSpeedButton({
            onClick: spy,
            speedValue,
        });

        component.find(Button).props().onClick();
        assert.equal(spy.callCount, 1, 'onClick prop was invoked');
        assert.equal(spy.firstCall.args[0], speedValue, 'was given speed value as a param');
    });
});
