import React from 'react';
import assign from 'lodash/assign';
import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { QualityButton } from 'ui/components/settings/quality-button';
import { Button } from 'ui/components/buttons/base-button';

const DEFAULT_ARGS = Object.freeze({
    isActive: false,
    qualityObj: {
        name: 'quality name',
    },
    onQualitySelect() {},
});

function renderQualityButton(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <QualityButton {...args} />;
    return shallow(component);
}

reactTest('ui | components | settings | quality-button', function() {
    QUnit.test('renders a div', function(assert) {
        const component = renderQualityButton();
        assert.equal(component.type(), 'div');
    });

    QUnit.test('onClick prop invokes onQualitySelect prop with qualityObj', function(assert) {
        const qualitySelectSpy = sinon.spy();
        const fakeQualityObj = {
            name: 'fake quality name',
        };

        const component = renderQualityButton({
            onQualitySelect: qualitySelectSpy,
            qualityObj: fakeQualityObj,
        });

        component.find(Button).prop('onClick')();

        assert.equal(qualitySelectSpy.callCount, 1, 'onQualitySelect prop was invoked');
        assert.deepEqual(qualitySelectSpy.firstCall.args[0], fakeQualityObj, 'prop was invoked with qualityObj');
    });

    QUnit.test('if isActive, includes active class', function(assert) {
        const component = renderQualityButton({
            isActive: true,
        });

        assert.ok(component.hasClass('pl-menu__item--active'));
    });
});
