import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { SettingsBanner } from 'ui/components/settings/settings-banner';

const DEFAULT_ARGS = Object.freeze({
    bannerLabel: '',
    showBanner: false,
});

function renderSettingsBanner(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <SettingsBanner {...args} />;
    return shallow(component);
}

reactTest('ui | components | settings | settings-banner', function() {
    QUnit.test('returns a div', function(assert) {
        const component = renderSettingsBanner();
        assert.equal(component.type(), 'div');
    });

    QUnit.test('if showBanner is true, add animateIn class', function(assert) {
        const component = renderSettingsBanner({
            showBanner: true,
        });

        assert.ok(component.find('.qa-settings-banner-span').hasClass('pl-settings-banner--animateIn'));
    });

    QUnit.test('if showBanner is false, add animateOut class', function(assert) {
        const component = renderSettingsBanner({
            showBanner: false,
        });

        assert.notOk(component.find('.qa-settings-banner-span').hasClass('pl-settings-banner--animateIn'));
    });
});
