import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { Button } from 'ui/components/buttons/base-button';
import { Icon } from 'ui/components/buttons/base-icon';
import { SettingsButton } from 'ui/components/settings/settings-button';

const DEFAULT_ARGS = Object.freeze({
    onClick() {},
    showSpinningAnimation: false,
});

function renderSettingsButton(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <SettingsButton {...args} />;
    return shallow(component);
}

reactTest('ui | components | settings | settings-button', function() {
    QUnit.test('returns a Button element', function(assert) {
        const component = renderSettingsButton();
        assert.equal(component.type(), Button);
    });

    QUnit.test('has the appropriate classname', function(assert) {
        const component = renderSettingsButton();
        assert.ok(component.hasClass('player-button--settings'));
    });

    QUnit.test('has an Icon child', function(assert) {
        const component = renderSettingsButton();
        assert.equal(component.childAt(0).type(), Icon);
    });

    QUnit.test('uses the icon_settings iconId', function(assert) {
        const component = renderSettingsButton();
        const iconChild = component.find(Icon);
        assert.equal(iconChild.props().iconId, '#icon_settings');
    });

    QUnit.test('passes in the onClick prop to Button', function(assert) {
        const component = renderSettingsButton();
        assert.equal(component.props().onClick, DEFAULT_ARGS.onClick);
    });

    QUnit.test('if showSpinningAnimation is true, has spin class on button', function(assert) {
        const component = renderSettingsButton({
            showSpinningAnimation: true,
        });

        assert.ok(component.find(Icon).props().iconClass.indexOf('pl-settings-icon--spin') >= 0);
    });
});
