import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { SliderLeft } from 'ui/components/slider/slider-left';

const DEFAULT_ARGS = Object.freeze({
    className: 'slider-left',
    min: 0,
    max: 100,
    value: 0,
});

function renderSliderLeft(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <SliderLeft {...args} />;
    return shallow(component);
}

reactTest('ui | components | slider | slider-left', function() {
    QUnit.test('sets className properly', function(assert) {
        const wrapper = renderSliderLeft();
        assert.ok(wrapper.hasClass(DEFAULT_ARGS.className));
    });

    QUnit.test('sets width to percentage of value compared to min and max values', function(assert) {
        const args = {
            value: 40,
        };
        const wrapper = renderSliderLeft(args);
        assert.equal(wrapper.prop('style').width, '40%');
    });
});
