import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { SliderThumb } from 'ui/components/slider/slider-thumb';

const DEFAULT_ARGS = Object.freeze({
    className: 'slider-thumb',
    max: 100,
    min: 0,
    value: 0,
});

function renderSliderThumb(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <SliderThumb {...args} />;
    return shallow(component);
}

reactTest('ui | components | slider | slider-thumb', function() {
    QUnit.test('component returns div', function(assert) {
        const component = renderSliderThumb();
        assert.equal(component.type(), 'div');
    });

    QUnit.test('sets left to percentage of value compared to min and max values', function(assert) {
        const args = {
            value: 40,
        };
        const component = renderSliderThumb(args);
        assert.equal(component.prop('style').left, '40%');
    });
});
