import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';
import { StatComponent } from 'ui/components/stats/stat';

const DEFAULT_ARGS = Object.freeze({
    statName: '',
    value: '',
    t: mockTranslateFunc,
});

function renderStatComponent(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <StatComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | stats | stat', function() {
    QUnit.test('should have the correct class', function(assert) {
        const component = renderStatComponent();
        assert.ok(component.hasClass('pl-playback-stats--stat'));
    });

    QUnit.test('should render the statName and the value', function(assert) {
        const statName = 'stat name';
        const value = QUnit.config.current.testId;

        const component = renderStatComponent({
            statName,
            value,
        });

        assert.equal(component.text(), `${statName}: ${value}`);
    });
});
