import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { WatchPartyDetails } from 'ui/components/stream-info/watch-party-details';

const DEFAULT_ARGS = Object.freeze({
    vodId: '12345',
    vodTitle: 'Test Title',
    isViewable: true,
});

function renderWatchPartyComponent(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <WatchPartyDetails {...args} />;
    return shallow(component);
}

reactTest('ui | components | top-bar | watch-party-details', function() {
    // eslint-disable-next-line max-len
    QUnit.test('when we dont have vod id should not render anything', function(assert) {
        const watchPartyComponent = renderWatchPartyComponent({
            vodId: '',
        });

        assert.ok(
            !watchPartyComponent.get(0),
            'should render an empty component'
        );
    });
    // eslint-disable-next-line max-len
    QUnit.test('when vod is viewable, render a link', function(assert) {
        const watchPartyComponent = renderWatchPartyComponent();

        assert.ok(
            watchPartyComponent.find('a').exists(),
            'should render a link'
        );
    });
    // eslint-disable-next-line max-len
    QUnit.test('when vod is not viewable, render a text', function(assert) {
        const watchPartyComponent = renderWatchPartyComponent({
            isViewable: false,
        });

        assert.ok(
            !watchPartyComponent.find('a').exists(),
            'should not render a link'
        );
        assert.ok(
            !watchPartyComponent.text().indexOf('Test Title') >= 0,
            'should render the title'
        );
    });
});
