import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { WatchPartyStreamInfoComponent, WATCH_PARTY_CLASSES } from 'ui/components/stream-info/watch-party';
import { WatchPartyDetails } from 'ui/components/stream-info/watch-party-details';

const DEFAULT_ARGS = Object.freeze({
    isWatchParty: true,
    vodId: '12345',
    vodTitle: 'Test Title',
    vodIsViewable: true,
    vodBroadcastType: 'highlight',
    t: s => s,
});

function renderWatchPartyStreamInfoComponent(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    return shallow(<WatchPartyStreamInfoComponent {...args} />);
}

reactTest('ui | components | top-bar | watch-party-component', function() {
    // eslint-disable-next-line max-len
    QUnit.test('given a watch party data, should render watch party component', function(assert) {
        const WatchPartyStreamInfoComponent = renderWatchPartyStreamInfoComponent();

        assert.ok(
            WatchPartyStreamInfoComponent.find(`.${WATCH_PARTY_CLASSES.container}`).exists(),
            'should render watch party component'
        );
        assert.ok(
            WatchPartyStreamInfoComponent.text().indexOf('Playing highlight') >= 0,
            'should classify the video as a highlight'
        );
        assert.ok(
            WatchPartyStreamInfoComponent.contains(
                <WatchPartyDetails
                    vodId={'12345'}
                    vodTitle={'Test Title'}
                    isViewable={true}
                />
            ),
            'should render the details component'
        );
    });
});

