import React from 'react';
import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { SubscribeButtonComponent, mapStateToProps } from 'ui/containers/buttons/subscribe-button';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

reactTest('ui | components | buttons | subscribe-button', function(hooks) {
    hooks.beforeEach(function() {
        this.args = {
            channelName: 'channel-name',
            isOwnChannel: false,
            isSubscribed: false,
            isSubscribable: true,
            onSubscribe: sinon.spy(),
            t: mockTranslateFunc,
        };
    });

    QUnit.test('mapStateToProps computes isOwnChannel', function(assert) {
        const mockedState = {
            streamMetadata: {
                channel: {
                    id: 123,
                },
            },
            user: {
                id: 123,
            },
            subscriptions: {},
        };

        const mockedProps = mapStateToProps(mockedState);
        assert.equal(mockedProps.isOwnChannel, true, 'isOwnChannel is truthy');

        const user = { id: 999 };
        const notOwnerState = Object.assign({}, mockedState, { user });
        const notOwnerProps = mapStateToProps(notOwnerState);
        assert.equal(notOwnerProps.isOwnChannel, false, 'isOwnChannel is falsey');
    });

    QUnit.test('when not subscribed', function(assert) {
        const component = shallow(
            <SubscribeButtonComponent {...this.args} />
        );

        assert.equal(component.childAt(0).text(), 'Subscribe to channel-name', 'shows subscribe message');

        component.simulate('click');

        assert.equal(this.args.onSubscribe.callCount, 1, 'subscribe was called');
    });

    QUnit.test('when subscribed', function(assert) {
        const component = shallow(
            <SubscribeButtonComponent {...this.args} isSubscribed={true} />
        );

        assert.equal(component.childAt(0).text(), 'Subscribed', 'shows subscribed message');

        component.simulate('click');

        assert.equal(this.args.onSubscribe.callCount, 1, 'subscribe was called');
    });

    QUnit.test('when channel does not have a subscription program', function(assert) {
        const component = shallow(
            <SubscribeButtonComponent {...this.args} isSubscribable={false} />
        );

        assert.equal(component.type(), null, 'component does not render a button');
    });
});
