import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { COLLECTION_EMPTY_SCREEN, CONTENT_SCREEN } from 'actions/screen';
import { CollectionEmptyOverlayContainer, mapStateToProps } from 'ui/containers/collections/collection-empty-overlay';
import {
    CollectionEmptyOverlay as CollectionEmptyOverlayComponent,
} from 'ui/components/collections/collection-empty-overlay';

const DEFAULT_ARGS = Object.freeze({
    shouldShow: false,
});

function renderCollectionEmptyOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <CollectionEmptyOverlayContainer {...args} />;
    return shallow(component);
}

reactTest('ui | containers | collections | collection-empty-overlay', function() {
    QUnit.test('renders the collection empty overlay when shouldShow is true', function(assert) {
        const component = renderCollectionEmptyOverlay();

        component.setProps({ shouldShow: false });
        assert.equal(component.type(), null);
        component.setProps({ shouldShow: true });
        assert.equal(component.type(), CollectionEmptyOverlayComponent);
    });

    QUnit.test('mapStateToProps creates correct props', function(assert) {
        const shouldShowState = {
            screen: [
                COLLECTION_EMPTY_SCREEN,
            ],
            ui: {
                isMini: false,
            },
        };
        const shouldNotShowState = {
            screen: [
                CONTENT_SCREEN,
            ],
            ui: {
                isMini: false,
            },
        };
        const shouldNotShowWhenMiniState = {
            screen: [
                COLLECTION_EMPTY_SCREEN,
            ],
            ui: {
                isMini: true,
            },
        };

        assert.equal(mapStateToProps(shouldShowState).shouldShow, true);
        assert.equal(mapStateToProps(shouldNotShowState).shouldShow, false);
        assert.equal(mapStateToProps(shouldNotShowWhenMiniState).shouldShow, false);
    });
});
