import React from 'react';
import assign from 'lodash/assign';
import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { ExperimentContainer } from 'ui/containers/common/experiments-container';

const DEFAULT_ARGS = Object.freeze({
    experiments: {
        get() {},
    },
    uuid: '',
    renderValue: '',
});

function renderExperimentContainer(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = (
        <ExperimentContainer {...args}>
            <div />
        </ExperimentContainer>
    );
    return shallow(component);
}

reactTest('ui | containers | experiments-container', function(hooks) {
    hooks.beforeEach(function() {
        this.mockExperiments = {
            get() {
                return Promise.resolve(QUnit.config.current.testId);
            },
        };
    });

    QUnit.test('should pass the specified UUID to experiment.get', function(assert) {
        sinon.spy(this.mockExperiments, 'get');
        const uuid = QUnit.config.current.testId;

        renderExperimentContainer({
            experiments: this.mockExperiments,
            uuid,
        });

        assert.equal(this.mockExperiments.get.callCount, 1);
        assert.equal(this.mockExperiments.get.firstCall.args[0], uuid);
    });

    QUnit.test('renders null if experimentValue is empty string', function(assert) {
        const get = sinon.spy(() => Promise.resolve(''));
        const component = renderExperimentContainer({
            renderValue: '',
            experiments: { get },
        });

        return get().
            then(() => {
                assert.equal(component.type(), null);
            });
    });

    QUnit.test('renders component if renderValue and exp value are the same', function(assert) {
        const component = renderExperimentContainer({
            renderValue: QUnit.config.current.testId,
            experiments: this.mockExperiments,
        });

        return this.mockExperiments.get().
            then(() => {
                component.update();
                assert.equal(component.type(), 'div');
            });
    });
});
