import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { DeadLTVOverlayComponent } from 'ui/containers/dead-ltv-overlay';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';
import { TYPE_DEAD_LTV } from 'state/stream-metadata';
import classNames from 'classnames';

reactTest('ui | containers | dead-ltv-overlay', function() {
    // helper function used to test same cases between these two modules
    function testCssAndText() {
        QUnit.test('should have correct css classes', function(assert) {
            const expectedClass = classNames(
                'pl-pinned-panel',
                'pl-pinned-panel--embed'
            );

            assert.ok(this.component.hasClass(expectedClass));
        });

        QUnit.test('should have the correct title text and class', function(assert) {
            const expectedText = 'Live Broadcast has ended';
            const titleClass = 'pl-pinned-panel__title';

            assert.equal(this.component.childAt(0).text(), expectedText);
            assert.ok(this.component.childAt(0).hasClass(titleClass));
        });
    }

    QUnit.module('when hideFollowPanel is false', function(hooks) {
        hooks.beforeEach(function() {
            const args = {
                t: mockTranslateFunc,
                hideFollowPanel: false,
                streamType: TYPE_DEAD_LTV,
            };
            this.component = shallow(<DeadLTVOverlayComponent {...args} />);
        });

        testCssAndText();

        QUnit.test('should have follow panel', function(assert) {
            assert.equal(
                this.component.childAt(1).name(),
                'Connect(WrappedFollowPanel(Translate(UnavailableContentFollowPanelComponent)))'
            );
        });
    });

    QUnit.module('when hideFollowPanel is true', function(hooks) {
        hooks.beforeEach(function() {
            const args = {
                t: mockTranslateFunc,
                hideFollowPanel: true,
                streamType: TYPE_DEAD_LTV,
            };
            this.component = shallow(<DeadLTVOverlayComponent {...args} />);
        });

        testCssAndText();

        QUnit.test('should not have follow panel', function(assert) {
            assert.equal(this.component.children().length, 1);
        });
    });

    QUnit.test('should not show when streamType is not TYPE_DEAD_LTV', function(assert) {
        const args = {
            t: mockTranslateFunc,
            hideFollowPanel: false,
            streamType: 'something else',
        };
        const component = shallow(<DeadLTVOverlayComponent {...args} />);
        assert.equal(component.type(), null);
    });
});
