import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { GenericFollowPanelContainer } from 'ui/containers/follow-panels/generic-panel';
import { CenteredFollowPanelContainer } from 'ui/containers/follow-panels/centered-panel';
import { FollowPanelContainer } from 'ui/containers/follow-panel';
import { PLAYER_EMBED, PLAYER_POPOUT, PLAYER_FACEBOOK,
         PLAYER_SITE, PLAYER_PULSE } from 'util/player-type';
import { TYPE_DEAD_LTV } from 'state/stream-metadata';

function renderFollowPanel(overrides = {}) {
    const args = assign({}, { playerType: '' }, overrides);
    const component = <FollowPanelContainer {...args} />;
    return shallow(component);
}

reactTest('ui | containers | follow-panel', function() {
    QUnit.test('if not a valid playerType, returns null', function(assert) {
        const component = renderFollowPanel({
            playerType: 'Not real player type',
        });

        assert.equal(component.type(), null);
    });

    function testDifferentPlayerTypes(playerType, expectedPanel) {
        QUnit.test(`renders ${playerType} panel`, function(assert) {
            const component = renderFollowPanel({
                playerType,
            });
            assert.equal(component.type(), expectedPanel);
        });
    }

    testDifferentPlayerTypes(PLAYER_SITE, GenericFollowPanelContainer);
    testDifferentPlayerTypes(PLAYER_POPOUT, GenericFollowPanelContainer);
    testDifferentPlayerTypes(PLAYER_EMBED, GenericFollowPanelContainer);
    testDifferentPlayerTypes(PLAYER_PULSE, CenteredFollowPanelContainer);
    testDifferentPlayerTypes(PLAYER_FACEBOOK, null);

    function testDifferentPlayerTypesDeadLTV(playerType) {
        QUnit.test(`does not render panel when on ${playerType} panel with dead ltv stream`, function(assert) {
            const component = renderFollowPanel({
                playerType: playerType,
                streamType: TYPE_DEAD_LTV,
            });
            assert.equal(component.type(), null);
        });
    }

    testDifferentPlayerTypesDeadLTV(PLAYER_SITE);
    testDifferentPlayerTypesDeadLTV(PLAYER_POPOUT);
    testDifferentPlayerTypesDeadLTV(PLAYER_EMBED);
    testDifferentPlayerTypesDeadLTV(PLAYER_FACEBOOK);
});
