import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { NotificationPopUpsContainer } from 'ui/containers/notifications-container';
import sinon from 'sinon';
import assign from 'lodash/assign';
import { MENU_STATE_SETTINGS, MENU_STATE_NONE } from 'actions/ui';

/* eslint-disable react/no-multi-comp */
function FirstPopUp() {
    return (
        <h1> first </h1>
    );
}

/* eslint-enable */

const notifications = [
    FirstPopUp,
];

const currentMenu = MENU_STATE_NONE;

const DEFAULT_ARGS = Object.freeze({
    notifications,
    i18n: {
        translate(string) {
            return string;
        },
    },
    currentMenu,
    removeCurrentNotification() {},
    windowObj: { },
});

function shallowRenderPopUpWrapper(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <NotificationPopUpsContainer {...args} />;
    return shallow(component);
}

reactTest('ui | containers | notification popups container', function() {
    QUnit.test('returns null if there are no notifications', function(assert) {
        const component = shallowRenderPopUpWrapper({
            notifications: [],
        });
        assert.equal(component.type(), null);
    });

    QUnit.test('removes notification on close', function(assert) {
        const removeCurrentNotification = sinon.spy();
        const component = shallowRenderPopUpWrapper({
            removeCurrentNotification,
        });
        const instance = component.instance();

        assert.ok(
            component.containsMatchingElement(<FirstPopUp />),
            'displays first popup'
        );
        instance.handleClose();

        assert.equal(removeCurrentNotification.callCount, 1);
    });

    QUnit.test('hides popup when menu is open', function(assert) {
        const component = shallowRenderPopUpWrapper();

        component.setProps({
            currentMenu: MENU_STATE_SETTINGS,
        });

        assert.equal(component.type(), null);
    });

    QUnit.test('shows popup when no menus are shown', function(assert) {
        const component = shallowRenderPopUpWrapper();

        component.setProps({
            currentMenu: MENU_STATE_NONE,
        });

        assert.equal(component.type(), FirstPopUp);
    });
});
