import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { AdOverlayContainer, mapStateToProps } from 'ui/containers/overlays/ad-overlay';
import { AdOverlay as AdOverlayComponent } from 'ui/components/overlays/ad-overlay';

const DEFAULT_ARGS = Object.freeze({
    clickThroughUrl: '',
    isPartner: true,
    displayName: 'channelName',
});

function renderAdOverlayContainer(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <AdOverlayContainer {...args} />;
    return shallow(component);
}

reactTest('ui | containers | overlays | ad-overlay', function() {
    QUnit.test('renders a AdOverlayComponent', function(assert) {
        const component = renderAdOverlayContainer();
        assert.equal(component.type(), AdOverlayComponent, 'renders AdOverlayComponent');
    });

    QUnit.test('renders a AdOverlayComponent and check adLabel', function(assert) {
        const component = renderAdOverlayContainer();
        assert.equal(component.props().adLabel,'This Ad supports channelName');
    });

    QUnit.test('mapStateToProps', function(assert) {
        const clickThrough = QUnit.config.current.testId;
        const state = {
            ads: {
                clickThrough,
            },
            streamMetadata: {
                channel: {
                    partner: true,
                    displayName: 'channelName',
                },
            },
        };
        let props = mapStateToProps(state);
        assert.equal(
            props.clickThroughUrl,
            clickThrough,
            'mapStateToProps passes clickThroughUrl'
        );

        state.streamMetadata.channel.partner = false;

        props = mapStateToProps(state);
        assert.equal(
            props.isPartner,
            false,
            'Advertisement'
        );
    });
});
