import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { ChromecastOverlayContainer } from 'ui/containers/overlays/chromecast-overlay';
import { ChromecastOverlay as ChromecastOverlayComponent } from 'ui/components/overlays/chromecast-overlay';
import { CONNECTED } from 'state/chromecast';

const DEFAULT_ARGS = Object.freeze({
    castingState: '',
    deviceName: '',
});

function renderChromecastOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ChromecastOverlayContainer {...args} />;
    return shallow(component);
}

reactTest('ui | containers | overlays | chromecast-overlay', function() {
    QUnit.test('renders null if castingState is not CONNECTED', function(assert) {
        const component = renderChromecastOverlay();
        assert.equal(component.type(), null, 'Nothing is rendered');
    });

    QUnit.test('renders a ChromecastOverlayComponent if castingState is CONNECTED', function(assert) {
        const component = renderChromecastOverlay({ castingState: CONNECTED });
        assert.equal(component.type(), ChromecastOverlayComponent);
    });

    QUnit.test('passes deviceName to child if castingState is CONNECTED', function(assert) {
        const deviceName = QUnit.config.current.testId;
        const component = renderChromecastOverlay({
            castingState: CONNECTED,
            deviceName,
        });

        assert.deepEqual(component.props(), { deviceName });
    });
});
