import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import sinon from 'sinon';
import { PlayerClickHandlerOverlayContainer } from 'ui/containers/overlays/player-click-handler-overlay';

const DEFAULT_ARGS = Object.freeze({
    isPaused: true,
    playVideo() {},
    pauseVideo() {},
    toggleFullScreen() {},
});

function renderPlayerClickHandlerOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <PlayerClickHandlerOverlayContainer {...args} />;
    return shallow(component);
}

reactTest('ui | containers | overlays | play-button-overlay', function() {
    QUnit.test('renders the player overlay div', function(assert) {
        const component = renderPlayerClickHandlerOverlay();
        assert.equal(component.find('.player-overlay').length, 1);
    });

    QUnit.test('pauses the player when playing and clicked', function(assert) {
        const pauseVideoSpy = sinon.spy();

        const component = renderPlayerClickHandlerOverlay({
            isPaused: false,
            pauseVideo: pauseVideoSpy,
        });

        assert.ok(!pauseVideoSpy.called);

        component.find('.player-overlay').simulate('click');

        assert.ok(pauseVideoSpy.called);
    });

    QUnit.test('plays the player when not playing and clicked', function(assert) {
        const playVideoSpy = sinon.spy();

        const component = renderPlayerClickHandlerOverlay({
            isPaused: true,
            playVideo: playVideoSpy,
        });

        assert.ok(!playVideoSpy.called);

        component.find('.player-overlay').simulate('click');

        assert.ok(playVideoSpy.called);
    });

    QUnit.test('toggles fullscreen on double click', function(assert) {
        const fullscreenToggleSpy = sinon.spy();

        const component = renderPlayerClickHandlerOverlay({
            toggleFullScreen: fullscreenToggleSpy,
        });

        assert.ok(!fullscreenToggleSpy.called);

        component.find('.player-overlay').simulate('dblclick');

        assert.ok(fullscreenToggleSpy.called);
    });
});
