import React from 'react';
import assign from 'lodash/assign';
import sinon from 'sinon';
import { shallow } from 'enzyme';
import { reactTest } from 'tests/utils/react-test';
import { StaffMenuContainer, mapDispatchToProps } from 'ui/containers/settings/staff-menu';
import { StaffMenu as StaffMenuComponent } from 'ui/components/settings/staff-menu';

const DEFAULT_ARGS = Object.freeze({
    onMenuTransition() {},
    onRunLocalPrerollAd() {},
    onRunLocalMidrollAd() {},
    onRunLocalPostrollAd() {},
});

function renderStaffMenu(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <StaffMenuContainer {...args} />;
    return shallow(component);
}

reactTest('ui | containers | settings | staff-menu', function() {
    QUnit.test('returns a StaffMenuComponent', function(assert) {
        const component = renderStaffMenu();
        assert.equal(component.type(), StaffMenuComponent, 'renders staff menu component');
    });

    QUnit.module('mapDispatchToProps', function() {
        QUnit.test('onRunLocalPrerollAd dispatches', function(assert) {
            const dispatchSpy = sinon.spy();
            const mappedDispatches = mapDispatchToProps(dispatchSpy);

            mappedDispatches.onRunLocalPrerollAd();
            assert.equal(dispatchSpy.callCount, 1, 'onRunLocalPrerollAd dispatched');
        });

        QUnit.test('onRunLocalMidrollAd dispatches', function(assert) {
            const dispatchSpy = sinon.spy();
            const mappedDispatches = mapDispatchToProps(dispatchSpy);

            mappedDispatches.onRunLocalMidrollAd();
            assert.equal(dispatchSpy.callCount, 1, 'onRunLocalMidrollAd dispatched');
        });

        QUnit.test('onRunLocalPostrollAd dispatches', function(assert) {
            const dispatchSpy = sinon.spy();
            const mappedDispatches = mapDispatchToProps(dispatchSpy);

            mappedDispatches.onRunLocalPostrollAd();
            assert.equal(dispatchSpy.callCount, 1, 'onRunLocalPostrollAd dispatched');
        });
    });
});
