import { unitTest } from 'tests/utils/module';
import { PlayerUIInfo } from 'ui/info';
import { init as initStore } from 'state';
import { setFullScreen, setTheatreMode } from 'actions/screen-mode';

unitTest('ui | info', function(hooks) {
    hooks.beforeEach(function() {
        this.api.setLoggedIn(false);

        this.root = window.document.createElement('div');

        this.mockPlayer = {
            addEventListener() {},
            getChannel() {
                return 'monstercat';
            },
            getEnded() {
                return false;
            },
            getVideo() {
                return false;
            },
            getPaused() {
                return false;
            },
            getReadyState() {
                return false;
            },
            getAutoplay() {
                return false;
            },
        };
        this.store = initStore();
        this.mockState = {
            addEventListener() {},
        };
        this.options = {};
    });

    QUnit.test('if options.showInfo, data-showinfo is true', function(assert) {
        this.options.showInfo = true;
        new PlayerUIInfo(this.mockPlayer, this.root, this.store, this.options);
        assert.equal(this.root.getAttribute('data-showinfo'), 'true');
    });

    QUnit.test('if in theatremode, data-showinfo is true', function(assert) {
        new PlayerUIInfo(this.mockPlayer, this.root, this.store, this.options);
        assert.equal(this.root.getAttribute('data-showinfo'), 'false');
        this.store.dispatch(setTheatreMode(true));
        assert.equal(this.root.getAttribute('data-showinfo'), 'true');
    });

    QUnit.test('if in fullscreen, data-showinfo is true', function(assert) {
        new PlayerUIInfo(this.mockPlayer, this.root, this.store, this.options);
        assert.equal(this.root.getAttribute('data-showinfo'), 'false');
        this.store.dispatch(setFullScreen(true));
        assert.equal(this.root.getAttribute('data-showinfo'), 'true');
    });
});
