import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { PlayerTypeLoaderComponent } from 'ui/player-type-loader';
import DefaultPlayerType from 'ui/player-types/default/default';
import AmazonLivePlayer from 'ui/player-types/amazon-live/default';
import ClipsViewingPlayer from 'ui/player-types/clips/viewing';
import { waitFor } from 'tests/utils/waitFor';

const DEFAULT_PROPS = Object.freeze({
    playerType: '',
    player: {},
    root: {},
});

function TestDiv() {
    return (
        <div />
    );
}

function renderPlayerLoader(opts = {}) {
    const props = assign({}, DEFAULT_PROPS, opts);
    const component = <PlayerTypeLoaderComponent {...props} />;
    return shallow(component);
}

reactTest('ui | containers | player-type-loader', function() {
    QUnit.test('renders DefaultPlayerType by default', function(assert) {
        const component = renderPlayerLoader();
        return waitFor(() => component.state().playerTypeComponent).then(() => {
            component.update();
            assert.equal(component.type(), DefaultPlayerType);
        });
    });

    QUnit.test('renders AmazonLivePlayer when type is amazon_live', function(assert) {
        const component = renderPlayerLoader({
            playerType: 'amazon_live',
        });
        return waitFor(() => component.state().playerTypeComponent).then(() => {
            component.update();
            assert.equal(component.type(), AmazonLivePlayer);
        });
    });

    QUnit.test('renders ClipsViewingPlayer when type is clips-viewing', function(assert) {
        const component = renderPlayerLoader({
            playerType: 'clips-viewing',
        });
        return waitFor(() => component.state().playerTypeComponent).then(() => {
            component.update();
            assert.equal(component.type(), ClipsViewingPlayer);
        });
    });

    QUnit.test('renders playerTypeComponent stored in state if it is set', function(assert) {
        const component = renderPlayerLoader();
        component.setState({
            playerTypeComponent: TestDiv,
        });

        assert.equal(component.type(), TestDiv);
    });
});
