import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import AmazonLivePlayer from 'ui/player-types/amazon-live/default';
import { ClosedCaptions } from 'ui/containers/closed-captions/closed-captions';
import { init as initStore } from 'state';
import { LoadingOverlay } from 'ui/containers/overlays/loading-overlay';

function renderAmazonLiveType(storeOverride) {
    const store = storeOverride || initStore();
    const component = <AmazonLivePlayer />;
    return shallow(component, {
        context: {
            store,
        },
    });
}

reactTest('ui | player-types | amazon-live | default', function(hooks) {
    hooks.beforeEach(function() {
        this.component = renderAmazonLiveType();
    });

    hooks.afterEach(function() {
        // To ensure that the Closed Captions Module is destroyed
        this.component.unmount();
    });

    QUnit.test('renders a div', function(assert) {
        assert.equal(this.component.type(), 'div');
    });

    QUnit.test('has a LoadingOverlay', function(assert) {
        assert.equal(this.component.find(LoadingOverlay).length, 1);
    });

    QUnit.test('has a ClosedCaptions container', function(assert) {
        assert.equal(this.component.find(ClosedCaptions).length, 1);
    });
});
